/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.SafeEncoder;

public class StreamEntryID
implements Comparable<StreamEntryID>,
Serializable {
    private static final long serialVersionUID = 1L;
    private long time;
    private long sequence;
    public static final StreamEntryID NEW_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "*";
        }
    };
    public static final StreamEntryID LAST_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "$";
        }
    };
    public static final StreamEntryID UNRECEIVED_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return ">";
        }
    };
    public static final StreamEntryID MINIMUM_ID = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "-";
        }
    };
    public static final StreamEntryID MAXIMUM_ID = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "+";
        }
    };

    public StreamEntryID() {
        this(0L, 0L);
    }

    public StreamEntryID(byte[] id) {
        this(SafeEncoder.encode(id));
    }

    public StreamEntryID(String id) {
        String[] split = id.split("-");
        this.time = Long.parseLong(split[0]);
        this.sequence = Long.parseLong(split[1]);
    }

    public StreamEntryID(long time) {
        this(time, 0L);
    }

    public StreamEntryID(long time, long sequence2) {
        this.time = time;
        this.sequence = sequence2;
    }

    public String toString() {
        return this.time + "-" + this.sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamEntryID other = (StreamEntryID)obj;
        return this.time == other.time && this.sequence == other.sequence;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(StreamEntryID other) {
        int timeCompare = Long.compare(this.time, other.time);
        return timeCompare != 0 ? timeCompare : Long.compare(this.sequence, other.sequence);
    }

    public long getTime() {
        return this.time;
    }

    public long getSequence() {
        return this.sequence;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.time);
        out.writeLong(this.sequence);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.time = in.readLong();
        this.sequence = in.readLong();
    }
}

